TITLE 								         { exa055.pde }
   'Positive and Negative Point Charges in (r,z)'	
SELECT
   spectral_colors
COORDINATES
   ycylinder( 'r', 'z')
DEFINITIONS                                     		
   Lr=2     Lz=1     d0=Lz/2     r0=5e-2     q=1          	
   eps0=8.85e-12     c=1/(4*pi*eps0)
   U=-q*c/sqrt(r^2+(z+d0)^2)+ q*c/sqrt(r^2+(z-d0)^2)
   Er=-dr(U)     Ez=-dz(U)                  		{ Field components }
   E=vector( Er, Ez)   Em=magnitude(E)                      			
   E_angle=sign( Ez)*arccos( Er/Em)/pi*180 	{ Degrees }
   D=eps0*E						{ Vector D }
BOUNDARIES
region 'domain'				{ With half-circular indentations }
   start (0,-Lz) line to (Lr,-Lz) to (Lr,Lz) to (0,Lz) to (0,d0+r0)
   arc(center=0,d0) angle=-180 to (0,d0-r0) line to (0,-d0+r0)
   arc(center=0,-d0) angle=-180 to (0,-d0-r0) line to close
feature  							{ For line integrals }
   start 'can' (0,-Lz)  line to (Lr,-Lz) to (Lr,Lz)  to (0,Lz)
   start 'half_can' (0,-Lz) line to (Lr,-Lz) to (Lr,0) to (0,0)
PLOTS
   contour( abs(U)) log	
   contour( abs(Er)) log   contour( abs(Ez)) log
   contour( Em) log   vector( E/Em)   contour( E_angle)
   elevation( normal(D)) on 'half_can'
   elevation( normal(D)*2*pi*r) area_integrate on 'half_can'	
   elevation( normal(D)) on 'can'
END


